in vec2 texCoord;
uniform sampler2D colorMap;
uniform vec4 glColor;
uniform float testvalue;
uniform float testvalue2;
uniform float blurradius;
uniform float intensity;

void main (void)
{
	float powf=2.0*1.15;//testvalue;
	const float xp=1.0/1920.0;
	const float yp=1.0/1080.0;
	float spread=2.0*blurradius;
	float cutoff=0.33-(0.1*testvalue2);//testvalue;
	float hicutoff=0.43+(0.15*testvalue2);//testvalue;
	vec4 col=texture2D(colorMap, texCoord);
	vec4 res=col;
	for (int i=-5;i<5;i+=1){
		for (int j=-5;j<5;j+=1){
			//vec4 curr=texture2D(colorMap, clamp(texCoord+vec2(xp*(float)i,yp*(float)j)*spread,0.0,0.1-1.0/1080.0));
			vec2 currtexcoo=texCoord+vec2(xp*(float)i,yp*(float)j)*spread;
			currtexcoo.x=clamp(currtexcoo.x,0,1.0-1.0/1920.0f);
			currtexcoo.y=clamp(currtexcoo.y,0,1.0-1.0/1080.0f);
			vec4 curr=texture2D(colorMap, currtexcoo);
			curr.r=pow(clamp(curr.r,0,1),powf);
			curr.g=pow(clamp(curr.g,0,1),powf);
			curr.b=pow(clamp(curr.b,0,1),powf);
			if (curr.r<cutoff) curr.r=0.0;
			if (curr.g<cutoff) curr.g=0.0;
			if (curr.b<cutoff) curr.b=0.0;
			curr=clamp(curr,0,hicutoff);
			res+=curr;
		}
	}
	res/=26.0*4.0*3.5*0.14*4.0 *2.4;
	col+=res;
	//col.r=1.0;
	vec4 col2=texture2D(colorMap, texCoord);
	col=mix(col,col2,intensity);

	gl_FragColor = col;
}
